program PlatformaIzolacyjna3;

uses
  SysUtils,
  DUnitX.TestFramework,
  DUnitX.Loggers.Console,
  DUnitX.Windows.Console,
  Delphi.Mocks in 'Delphi.Mocks.pas',
  Delphi.Mocks.Behavior in 'Delphi.Mocks.Behavior.pas',
  Delphi.Mocks.Helpers in 'Delphi.Mocks.Helpers.pas',
  Delphi.Mocks.Interfaces in 'Delphi.Mocks.Interfaces.pas',
  Delphi.Mocks.MethodData in 'Delphi.Mocks.MethodData.pas',
  Delphi.Mocks.Utils in 'Delphi.Mocks.Utils.pas',
  Delphi.Mocks.VirtualInterface in 'Delphi.Mocks.VirtualInterface.pas',
  Delphi.Mocks.When in 'Delphi.Mocks.When.pas',
  Delphi.Mocks.Expectation in 'Delphi.Mocks.Expectation.pas',
  Delphi.Mocks.ObjectProxy in 'Delphi.Mocks.ObjectProxy.pas',
  Delphi.Mocks.Proxy in 'Delphi.Mocks.Proxy.pas',
  Delphi.Mocks.VirtualMethodInterceptor in 'Delphi.Mocks.VirtualMethodInterceptor.pas',
  Delphi.Mocks.ReturnTypePatch in 'Delphi.Mocks.pas';

type
  ISerwerPocztowy = interface(IInvokable)
    ['{68553321-248C-4FD4-9881-C6B6B92B95AD}']
    procedure WylijWiadomo(aAdresEmail, Komunikat: string);
    procedure WylijSeriWiadomoci;
  end;

  TSystemObsugiListyWysykowej = class
  private
    FSerwerPocztowy: ISerwerPocztowy;
  public
    constructor Create(aSerwerPocztowy: ISerwerPocztowy);
    procedure ZarejestrujNowOsob(aNazwisko: string; aAdresEmail: string);
  end;

{...}

constructor TSystemObsugiListyWysykowej.Create(aSerwerPocztowy: ISerwerPocztowy);
begin
  inherited Create;
  FSerwerPocztowy := aSerwerPocztowy;
end;

procedure TSystemObsugiListyWysykowej.ZarejestrujNowOsob(aNazwisko, aAdresEmail: string);
begin
  // Wpisanie nazwiska i adresu e-mail do bazy danych
  // i wysanie wiadomoci z potwierdzeniem
  FSerwerPocztowy.WylijWiadomo(aAdresEmail, 'Dzikujemy za rejestracj!');
end;

// -----------------------------------------------------------------------------

type
  [TestFixture]
  TTestSystemuObsugiListyWysykowej = class
     public
     [Test]
     procedure TestDodaniaNowejOsobyIWysaniaJednejWiadomoci;
  end;

procedure TTestSystemuObsugiListyWysykowej.TestDodaniaNowejOsobyIWysaniaJednejWiadomoci;
var
  TestowanaKlasa: TSystemObsugiListyWysykowej;
  ImitowanySerwerPocztowy: TMock<ISerwerPocztowy>;
  AdresTestowy, KomunikatTestowy: string;
begin
  // Przygotuj
  AdresTestowy := 'jan.nowak@gmail.com';
  KomunikatTestowy := 'Dzikujemy za rejestracj na naszej licie!';
  ImitowanySerwerPocztowy := TMock<ISerwerPocztowy>.Create;
  ImitowanySerwerPocztowy.Setup.Expect.Once.When.WylijWiadomo(AdresTestowy, KomunikatTestowy);
  ImitowanySerwerPocztowy.Setup.Expect.Never.When.WylijSeriWiadomoci;

  TestowanaKlasa := TSystemObsugiListyWysykowej.Create(ImitowanySerwerPocztowy);
  try
    // Wykonaj
    TestowanaKlasa.ZarejestrujNowOsob('Jan Nowak', AdresTestowy);
  finally
    TestowanaKlasa.Free;
  end;

  // Sprawd
  ImitowanySerwerPocztowy.Verify();
end;

var
  Runner: ITestRunner;
  Logger: ITestLogger;
  Results: IRunResults;

begin
  TDUnitX.RegisterTestFixture(TTestSystemuObsugiListyWysykowej);
  try
    // Utworzenie zmiennej testowej
    Runner := TDUnitX.CreateRunner;
    Runner.UseRTTI := True;
    // Wskazanie sposobu rejestrowania wynikw testw
    Logger := TDUnitXConsoleLogger.Create;
    Runner.AddLogger(Logger);
    // Wykonanie testw
    Results := Runner.Execute;
    System.Write('Koniec. Nacinij <Enter> aby zakoczy.');
    System.Readln;
  except
    on E: Exception do
      System.Writeln(E.ClassName, ': ', E.Message);
  end;

end.